%------------------------------------------------------------------------------
% File     : CSR145^3 : TPTP v9.2.0. Released v4.1.0.
% Domain   : Commonsense Reasoning
% Problem  : What is the relation between Chris and Corina?
% Version  : Especial.
% English  : Corina is the wife of Chris. There is some person Chris is not 
%            husband of. What is the relationship between Chris and Corina?

% Refs     : [Ben10] Benzmueller (2010), Email to Geoff Sutcliffe
% Source   : [Ben10]
% Names    : ex_4.tq_SUMO_local [Ben10]

% Status   : CounterSatisfiable
% Rating   : 0.67 v9.0.0, 1.00 v8.1.0, 0.40 v7.4.0, 0.50 v7.2.0, 0.33 v6.4.0, 1.00 v6.0.0, 0.86 v5.5.0, 0.83 v5.4.0, 0.80 v4.1.0
% Syntax   : Number of formulae    :    8 (   1 unt;   5 typ;   0 def)
%            Number of atoms       :    6 (   1 equ;   2 cnn)
%            Maximal formula atoms :    2 (   2 avg)
%            Number of connectives :   11 (   2   ~;   0   |;   1   &;   8   @)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    5 (   4 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :    6 (   6   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    7 (   4 usr;   4 con; 0-2 aty)
%            Number of variables   :    4 (   2   ^;   0   !;   2   ?;   4   :)
% SPC      : TH0_CSA_EQU_NAR

% Comments : This is a simple test problem for reasoning in/about SUMO.
%            Initally the problem has been hand generated in KIF syntax in
%            SigmaKEE and then automatically translated by Benzmueller's
%            KIF2TH0 translator into THF syntax.
%          : The translation has been applied in three modes: handselected,
%            SInE, and local. The local mode only translates the local
%            assumptions and the query. The SInE mode additionally translates
%            the SInE extract of the loaded knowledge base (usually SUMO). The
%            handselected mode contains a hand-selected relevant axioms.
%          : The examples are selected to illustrate the benefits of
%            higher-order reasoning in ontology reasoning.
%------------------------------------------------------------------------------
%----The extracted signature
thf(numbers,type,
    num: $tType ).

thf(husband_THFTYPE_IiioI,type,
    husband_THFTYPE_IiioI: $i > $i > $o ).

thf(lChris_THFTYPE_i,type,
    lChris_THFTYPE_i: $i ).

thf(lCorina_THFTYPE_i,type,
    lCorina_THFTYPE_i: $i ).

thf(wife_THFTYPE_IiioI,type,
    wife_THFTYPE_IiioI: $i > $i > $o ).

%----The translated axioms
thf(ax,axiom,
    ? [X: $i] : ( (~) @ ( husband_THFTYPE_IiioI @ lChris_THFTYPE_i @ X ) ) ).

thf(ax_001,axiom,
    wife_THFTYPE_IiioI @ lCorina_THFTYPE_i @ lChris_THFTYPE_i ).

%----The translated conjectures
thf(con,conjecture,
    ? [R: $i > $i > $o] :
      ( ( R @ lChris_THFTYPE_i @ lCorina_THFTYPE_i )
      & ( (~)
        @ ( R
          = ( ^ [X: $i,Y: $i] : $true ) ) ) ) ).

%------------------------------------------------------------------------------
